<?php

/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

print_cp_header($vbphrase['dbtech_downloads']);

print_table_start();
print_table_header($vbphrase['dbtech_downloads_extensions'], 6);

$getextgroups = $db->query_read("
	SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_extension_groups
	ORDER BY groupname ASC
");

$extgroups = array();
while($extgroup = $db->fetch_array($getextgroups)) {
	$extgroups[$extgroup['extgroupid']]['groupname'] = $extgroup['groupname'];
}

$grab_extensions = $db->query_read("
	SELECT extensionid, extension, mime, maxsize, maxwidth, maxheight, extgroupid FROM " . TABLE_PREFIX . "dbtech_downloads_extensions
	ORDER BY extension ASC
");

print_cells_row(array(
	'<span style="font-size: 15px;">' . $vbphrase['dbtech_downloads_extension'] . '</span>',
	'<span style="font-size: 15px;">' . $vbphrase['dbtech_downloads_mime_type'] . '</span>',
	'<span style="font-size: 15px;">' . $vbphrase['dbtech_downloads_max_file_size'] . '</span>',
	'<span style="font-size: 15px;">' . $vbphrase['dbtech_downloads_max_width'] . '</span>',
	'<span style="font-size: 15px;">' . $vbphrase['dbtech_downloads_max_height'] . '</span>',
	'<span style="font-size: 15px;">' . $vbphrase['dbtech_downloads_controls'] . '</span>'
), true);


while ($extensions = $db->fetch_array($grab_extensions)) {
	$extgroups[$extensions['extgroupid']]['extensions'][] = $extensions;
}

foreach ($extgroups AS $extgroupid => $extgroup) {
	print_cells_row(array(
		$extgroup['groupname'],
		'',
		'',
		'',
		'',
		'<a href="vbdownloads.php?do=removeextensiongroup&amp;extensiongroupid=' . $extgroupid . '">[' . $vbphrase['dbtech_downloads_remove'] . ']</a>',
	), 1);
	
	foreach ((array)$extgroup['extensions'] AS $i => $extensions) {
		$extensions['maxsize'] = Downloads::convert_filesize($extensions['maxsize']);
	
		$extensions['controls'] = '<a href="vbdownloads.php?do=manageextension&amp;extensionid=' . $extensions['extensionid'] . '">[' . $vbphrase['dbtech_downloads_manage'] . ']</a> <a href="vbdownloads.php?do=removeextension&amp;extensionid=' . $extensions['extensionid'] . '">[' . $vbphrase['dbtech_downloads_remove'] . ']</a>';
		unset($extensions['extgroupid'], $extensions['extensionid']);
		
		print_cells_row($extensions);
	}
}


print_table_footer(6, '<a href="vbdownloads.php?do=addextension">[' . $vbphrase['dbtech_downloads_add_new_extension'] . ']</a> <a href="vbdownloads.php?do=addextgroup">[' . $vbphrase['dbtech_downloads_add_extension_group'] . ']</a>');

print_cp_footer();

?>